#include <iostream>
#include <vector>

using namespace std;

int n, m;
vector<vector<int>> G;

bool isFounded = false;
vector<int> goodPath;

void dfs(int v, vector<bool> used, vector<int> path) {
  if (isFounded)
    return;
  used[v] = true;
  path.push_back(v);
  for (int i = 0; i < G[v].size(); i++) {
    if (G[v][i] == 0) {
      if (path.size() == n) {
        isFounded = true;
	goodPath = path;
	break;
      }
    }
    if (!used[G[v][i]])
      dfs(G[v][i], used, path);
  }
}

int main() {
  scanf("%d%d", &n, &m);
  if (m < n) {
    printf("NO");
    return 0;
  }
  G.resize(n);
  int from, to;
  for (int i = 0; i < m; i++) {
    scanf("%d%d", &from, &to);
    G[from - 1].push_back(to - 1);
  }
  vector<bool> used(n, false);
  dfs(0, used, {});
  if (!isFounded)
    printf("NO\n");
  else {
    printf("YES\n");
    for (int i = 0; i < n; i++)
      printf("%d ", goodPath[i] + 1);
    printf("1\n");
  }
}
